/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.heif;

import com.drew.imaging.FileType;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.twelvemonkeys.imageio.ImageReaderBase;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.ddr.image.ImageInputStreamWrapper;
import org.ddr.image.heif.HeicOnlineParam;
import org.ddr.image.heif.HeifMetadataReader;
import org.ddr.poi.util.HttpURLConnectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeifImageReader
extends ImageReaderBase {
    private static final Logger log = LoggerFactory.getLogger(HeifImageReader.class);
    private final HeifMetadataReader metadataReader = new HeifMetadataReader();
    private Metadata metadata;
    private Dimension dimension;

    public HeifImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    protected void resetMembers() {
        this.metadata = null;
        this.dimension = null;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (this.imageInput != null) {
            ImageInputStreamWrapper wrapper = new ImageInputStreamWrapper(this.imageInput);
            try {
                this.metadata = ImageMetadataReader.readMetadata((InputStream)wrapper, (long)0L, (FileType)FileType.Heif);
                this.dimension = this.metadataReader.getDimension(this.metadata);
            }
            catch (ImageProcessingException | IOException e) {
                log.warn("Failed to read metadata", e);
            }
        }
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.dimension == null ? 0 : this.dimension.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.dimension == null ? 0 : this.dimension.height;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        return this.convert(this.imageInput, param);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BufferedImage convert(ImageInputStream input, ImageReadParam param) throws IOException {
        HttpURLConnection uploadConnection = null;
        HttpURLConnection convertConnection = null;
        HttpURLConnection downloadConnection = null;
        HeicOnlineParam heicOnlineParam = param instanceof HeicOnlineParam ? (HeicOnlineParam)param : new HeicOnlineParam();
        try {
            String json;
            String fileId;
            uploadConnection = HttpURLConnectionUtils.connect("https://s1.heic.online/heic/");
            uploadConnection.setRequestMethod("POST");
            uploadConnection.setDoOutput(true);
            uploadConnection.setRequestProperty("X-File-Name", "public.heic");
            uploadConnection.setRequestProperty("Content-Type", "application/octet-stream");
            uploadConnection.setRequestProperty("Origin", "https://heic.online");
            uploadConnection.setRequestProperty("Referer", "https://heic.online/");
            try (OutputStream outputStream = uploadConnection.getOutputStream();){
                int n;
                byte[] buffer = new byte[8192];
                while (-1 != (n = input.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                outputStream.flush();
            }
            int uploadResponseCode = uploadConnection.getResponseCode();
            try (InputStream uploadResponse = uploadConnection.getInputStream();){
                fileId = IOUtils.toString((InputStream)uploadResponse, (Charset)StandardCharsets.UTF_8).trim();
            }
            if (uploadResponseCode != 200) {
                log.warn("Failed to upload image. Response code: {}, {}", (Object)uploadResponseCode, (Object)fileId);
                return null;
            }
            log.debug("Heic uploaded: {}", (Object)fileId);
            convertConnection = HttpURLConnectionUtils.connect("https://s1.heic.online/heic/");
            convertConnection.setRequestMethod("POST");
            convertConnection.setDoOutput(true);
            convertConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            convertConnection.setRequestProperty("Referer", "https://heic.online/");
            String data = heicOnlineParam.withId(fileId);
            convertConnection.setRequestProperty("Content-Length", String.valueOf(data.length()));
            try (OutputStream convertOutput = convertConnection.getOutputStream();){
                IOUtils.write((String)data, (OutputStream)convertOutput, (Charset)StandardCharsets.UTF_8);
            }
            int convertResponseCode = convertConnection.getResponseCode();
            try (InputStream convertResponse = convertConnection.getInputStream();){
                json = IOUtils.toString((InputStream)convertResponse, (Charset)StandardCharsets.UTF_8);
            }
            if (convertResponseCode == 200 && json.contains("SUCCESS")) {
                log.debug("Heic converted: {}", (Object)json);
                String url = "https://s1.heic.online/upload/" + fileId + "/";
                downloadConnection = HttpURLConnectionUtils.connect(url);
                try (InputStream downloadResponse = downloadConnection.getInputStream();){
                    BufferedImage bufferedImage = ImageIO.read(downloadResponse);
                    return bufferedImage;
                }
            }
            log.warn("Failed to convert heic image. Response code: {}, {}", (Object)convertResponseCode, (Object)json);
            return null;
        }
        catch (Exception e) {
            log.warn("Failed to convert heic image", (Throwable)e);
            IOUtils.close((URLConnection)uploadConnection);
            IOUtils.close(convertConnection);
            IOUtils.close(downloadConnection);
        }
        return null;
    }
}

