/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import org.apache.commons.lang3.StringUtils;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.ListStyleType;
import org.jsoup.nodes.Element;

public class ListRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"ul", "ol"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        context.getNumberingContext().startLevel(this.determineNumberFormat(context, element));
        return true;
    }

    private ListStyleType determineNumberFormat(HtmlRenderContext context, Element element) {
        ListStyleType format;
        String listStyleType = context.currentElementStyle().getPropertyValue("list-style-type").toLowerCase();
        switch (element.tag().normalName()) {
            case "ol": {
                if (StringUtils.isNotBlank((CharSequence)listStyleType)) {
                    format = ListStyleType.Ordered.of(listStyleType);
                    break;
                }
                String type = element.attr("type");
                format = ListStyleType.Ordered.of(type);
                break;
            }
            case "ul": {
                format = ListStyleType.Unordered.of(listStyleType);
                break;
            }
            default: {
                format = ListStyleType.Unordered.NONE;
            }
        }
        return format;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        context.getNumberingContext().endLevel();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

