/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.latex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ddr.poi.latex.TagHandler;
import org.ddr.poi.latex.TextCircledHandler;
import org.ddr.poi.math.MathMLUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.MathComplexCommandHandler;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.DefaultTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public class LaTeXUtils {
    private static final Logger log = LoggerFactory.getLogger(LaTeXUtils.class);
    public static final String TAG_MATH = "math";
    public static final String TAG_TAG = "tag";
    static final ConcurrentHashMap<String, String> textCircledMap = new ConcurrentHashMap();

    public static SnuggleSession createSession() {
        return Initializer.SNUGGLE_ENGINE.createSession();
    }

    public static boolean parse(SnuggleSession session, String data) {
        SnuggleInput input = new SnuggleInput(data);
        boolean valid = false;
        try {
            valid = session.parseInput(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (CollectionUtils.isNotEmpty((Collection)session.getErrors())) {
            log.warn("Invalid LaTex: {}", (Object)data);
            for (InputError error : session.getErrors()) {
                log.warn("LaTeX parse error: {}", (Object)error);
            }
        }
        return valid;
    }

    public static void renderTo(XWPFParagraph paragraph, CTR ctr, SnuggleSession session) {
        CTR target = ctr;
        NodeList nodeList = session.buildDOMSubtree();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                target = paragraph.getCTP().addNewR();
                target.addNewT().setStringValue(node.getTextContent());
                continue;
            }
            if (TAG_MATH.equals(node.getLocalName())) {
                String math = XMLUtilities.serializeNode((Node)node, (SerializationSpecifier)Initializer.SNUGGLE_ENGINE.getDefaultXMLStringOutputOptions());
                MathMLUtils.renderTo(paragraph, target, math);
                continue;
            }
            if (!TAG_TAG.equals(node.getLocalName())) continue;
            LaTeXUtils.renderTag(paragraph, ctr, node);
        }
    }

    private static void renderTag(XWPFParagraph paragraph, CTR ctr, Node node) {
        XmlCursor pCursor = paragraph.getCTP().newCursor();
        pCursor.push();
        XWPFTable xwpfTable = paragraph.getBody().insertNewTbl(pCursor);
        xwpfTable.setWidth(5000);
        xwpfTable.setWidthType(TableWidthType.PCT);
        xwpfTable.setLeftBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.setTopBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.setRightBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.setBottomBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.setInsideHBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.setInsideVBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, "000000");
        xwpfTable.removeRow(0);
        XWPFTableRow row = xwpfTable.createRow();
        XWPFTableCell mathCell = row.createCell();
        XWPFParagraph mathParagraph = (XWPFParagraph)mathCell.getParagraphs().get(0);
        XmlCursor copyCursor = mathParagraph.getCTP().newCursor();
        copyCursor.toEndToken();
        pCursor.pop();
        pCursor.toFirstChild();
        boolean hasNextSibling = true;
        while (hasNextSibling) {
            XmlObject obj = pCursor.getObject();
            if (obj instanceof CTPPr) {
                pCursor.copyXml(copyCursor);
                hasNextSibling = pCursor.toNextSibling();
                continue;
            }
            if (obj == null || obj instanceof CTBookmark || ctr.equals(obj)) {
                hasNextSibling = pCursor.toNextSibling();
                continue;
            }
            hasNextSibling = pCursor.moveXml(copyCursor);
        }
        copyCursor.dispose();
        pCursor.dispose();
        String math = XMLUtilities.serializeNode((Node)node.getFirstChild(), (SerializationSpecifier)Initializer.SNUGGLE_ENGINE.getDefaultXMLStringOutputOptions());
        MathMLUtils.renderTo(mathParagraph, mathParagraph.createRun().getCTR(), math);
        XWPFTableCell tagCell = row.createCell();
        tagCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
        XWPFParagraph tagParagraph = (XWPFParagraph)tagCell.getParagraphs().get(0);
        String tag = XMLUtilities.serializeNode((Node)node.getLastChild(), (SerializationSpecifier)Initializer.SNUGGLE_ENGINE.getDefaultXMLStringOutputOptions());
        MathMLUtils.renderTo(tagParagraph, tagParagraph.createRun().getCTR(), tag);
    }

    private static class Initializer {
        static final SnuggleEngine SNUGGLE_ENGINE = new SnuggleEngine((TransformerFactoryChooser)DefaultTransformerFactoryChooser.getInstance(), null);

        private Initializer() {
        }

        static {
            CorePackageDefinitions.getPackage().loadMathCharacterAliases("math-character-aliases.txt");
            CorePackageDefinitions.getPackage().addComplexCommandSameArgMode("dfrac", false, 2, Globals.MATH_MODE_ONLY, (CommandHandler)new MathComplexCommandHandler("mfrac"), null);
            try (InputStream is = Globals.class.getClassLoader().getResourceAsStream("math-character-circled.txt");
                 InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    line = line.replaceFirst("\\s+#.+$", "");
                    String[] fields = line.split("->");
                    textCircledMap.put(fields[0], fields[1].trim());
                }
            }
            catch (IOException e) {
                log.warn("Failed to load math-character-circled.txt", (Throwable)e);
            }
            CorePackageDefinitions.getPackage().addComplexCommandOneArg("textcircled", false, Globals.ALL_MODES, LaTeXMode.LR, (CommandHandler)new TextCircledHandler(), null);
            CorePackageDefinitions.getPackage().addComplexCommandOneArg(LaTeXUtils.TAG_TAG, false, Globals.ALL_MODES, LaTeXMode.LR, (CommandHandler)new TagHandler(), null);
        }
    }
}

